function bundle {
   local ext=$(basename ${SHELL})
   local folder="${HOME}/.config/bundle/bundle.d /etc/bundle/bundle.d"

   case "$1" in
      avail)
         for d in ${folder}
         do
            if [ -d "$d" ]
            then
               echo "   --- folder $d"
               ( cd "$d" ; find . -type f -a -name "*.${ext}" | sed -e "s/.\///; s/\.${ext}\$//" )
            fi
         done
         ;;

      load)
         pack=$(find ${folder} -type f -a -name "*.${ext}" -print0 2> /dev/null | grep -FzZ "/$2.${ext}" | head -n 1 )
         if [ -f "${pack}" ]
         then
            export _bundle_name="$2"
            let _bundle_level++
            export _bundle_level
            export _bundle_status="${_bundle_status}:$2"
            $VERBOSE && echo "Begin bundle: ${_bundle_name}"
            ${SHELL} --rcfile ${pack}
            $VERBOSE && echo "End bundle: ${_bundle_name}"
            unset _bundle_name
            let _bundle_level--
            [ ${_bundle_level} -eq 0 ] && unset _bundle_level
            export _bundle_status=$(echo "${_bundle_status}" | sed 's/:[^:]*$//')
            [ "${_bundle_status}" == "" ] && unset _bundle_status
         else
            echo "unable to load bundle file: $2"
            echo "Usage: bundle load bundle-file"
         fi
         ;;

      unload)
         if [ ${_bundle_level} > 0 ]
         then
            exit
         else
            echo "Error: not a bundle environment!"
         fi
         ;;

      list)
         if [ ${_bundle_level} > 0 ]
         then
            echo "${_bundle_status}" | sed 's/^://'
         else
            echo "Error: not a bundle environment!"
         fi
         ;;

      status)
         if [ ${_bundle_level} > 0 ]
         then
            echo "bundle environment active"
         else
            echo "not a bundle environment"
         fi
         ;;

      source)
         pack=$(find ${folder} -type f -a -name "*.${ext}" -print0 2> /dev/null | grep -FzZ "/$2.${ext}" | head -n 1 )
         if [ -f "${pack}" ]
         then
            . ${pack}
         else
            echo "Usage: bundle source bundle-file"
         fi
         ;;

      *)
         echo "Usage: bundle list|avail|load|unload|status|source|help"
         ;;
   esac
   }

typeset -fx bundle

return

################################################################
# Documentation in POD format (like Perl)
################################################################

=head1 NAME

bundle - load specific environment in current shell

=head1 SYNOPSIS

=head1 SYNOPSIS

 bundle list

 bundle load bundle-file
 bundle unload

 bundle source

 bundle help

=head1 DESCRIPTION

C<bundle> can load a new environment in current shell
or laod it in a sub-shell.


=head1 SEE ALSO

sysprofile, module


=head1 AUTHORS

Written by Gabriel Moreau, Grenoble - France


=head1 LICENSE AND COPYRIGHT

GPL version 2 or later

Copyright (C) 2011 Gabriel Moreau / LEGI - CNRS UMR 5519 - France
