%'rotate_points': associated with GUI rotate_points.fig to introduce (2D) rotation parameters
%------------------------------------------------------------------------
% function T=rotate_points(Tinput)
% OUTPUT:
% T=vector size(1,3)
%     T(1): rotation angle
%     T(2): x coordiante of rotation axis
%     T(3): y coordiante of rotation axis
%
%INPUT:
% Tinput: like T, used to prefil the GUI edit boxs

%=======================================================================
% Copyright 2008-2018, LEGI UMR 5519 / CNRS UGA G-INP, Grenoble, France
%   http://www.legi.grenoble-inp.fr
%   Joel.Sommeria - Joel.Sommeria (A) legi.cnrs.fr
%
%     This file is part of the toolbox UVMAT.
%
%     UVMAT is free software; you can redistribute it and/or modify
%     it under the terms of the GNU General Public License as published
%     by the Free Software Foundation; either version 2 of the license,
%     or (at your option) any later version.
%
%     UVMAT is distributed in the hope that it will be useful,
%     but WITHOUT ANY WARRANTY; without even the implied warranty of
%     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%     GNU General Public License (see LICENSE.txt) for more details.
%=======================================================================

function varargout = rotate_points(varargin)

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @rotate_points_OpeningFcn, ...
                   'gui_OutputFcn',  @rotate_points_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before rotate_points is made visible.
function rotate_points_OpeningFcn(hObject, eventdata, handles,input_shift)
% This function has no output args, see OutputFcn.

% Choose default command line output for rotate_points
handles.output = 'Cancel';

% Update handles structure
guidata(hObject, handles);
testNo=0;
testCancel=1;
testinputstring=0;
icontype='quest';%default question icon (text input asked)

% Determine the position of the dialog - centered on the screen
FigPos=get(0,'DefaultFigurePosition');
OldUnits = get(hObject, 'Units');
set(hObject, 'Units', 'pixels');
OldPos = get(hObject,'Position');
FigWidth = OldPos(3);
FigHeight = OldPos(4);
ScreenUnits=get(0,'Units');
set(0,'Units','pixels');
ScreenSize=get(0,'ScreenSize');
set(0,'Units',ScreenUnits);

FigPos(1)=1/2*(ScreenSize(3)-FigWidth);
FigPos(2)=2/3*(ScreenSize(4)-FigHeight);
FigPos(3:4)=[FigWidth FigHeight];
set(hObject, 'Position', FigPos);
set(hObject, 'Units', OldUnits);

% Show a question icon from dialogicons.mat - variables questIconData and questIconMap
load dialogicons.mat
eval(['IconData=' icontype 'IconData;'])
eval(['IconCMap=' icontype 'IconMap;'])
questIconMap(256,:) = get(handles.figure1, 'Color');
Img=image(IconData, 'Parent', handles.axes1);
set(handles.figure1, 'Colormap', IconCMap);
set(handles.axes1, ...
    'Visible', 'off', ...
    'YDir'   , 'reverse'       , ...
    'XLim'   , get(Img,'XData'), ...
    'YLim'   , get(Img,'YData')  ...
    );

if exist('input_shift','var') && ~isempty(input_shift)
   set(handles.Phi,'String',num2str(input_shift(1)));
   if numel(input_shift)>=2
    set(handles.x_0,'String',num2str(input_shift(2)));
   end
   if numel(input_shift)>=3
    set(handles.y_0,'String',num2str(input_shift(3)));
   end
end

set(handles.figure1,'WindowStyle','modal')% Make% Make the GUI modal 
% UIWAIT makes rotate_points wait for user response (see UIRESUME)
uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = rotate_points_OutputFcn(hObject, eventdata, handles)

% Get default command line output from handles structure
varargout{1}=[0 0 0];%default
if ~isequal(handles.output,'Cancel')
    x_shift=str2num(get(handles.Phi,'String'));
    y_shift=str2num(get(handles.x_0,'String'));
    z_shift=str2num(get(handles.y_0,'String'));
    if ~isempty(x_shift)
        varargout{1}(1)=x_shift;
    end
    if ~isempty(y_shift)
        varargout{1}(2)=y_shift;
    end
    if ~isempty(z_shift)
        varargout{1}(3)=z_shift;
    end
end
% The figure can be deleted now
delete(handles.figure1);

% --- Executes on button press in OK.
function OK_Callback(hObject, eventdata, handles)
handles.output = get(hObject,'String');
guidata(hObject, handles);% Update handles structure
uiresume(handles.figure1);

% --- Executes on button press in Cancel.
function Cancel_Callback(hObject, eventdata, handles)
handles.output = get(hObject,'String');
%handles.output = 'Cancel'
guidata(hObject, handles); % Update handles structure
% Use UIRESUME instead of delete because the OutputFcn needs
% to get the updated handles structure.
uiresume(handles.figure1);

% --- Executes when user attempts to close figure1.
function figure1_CloseRequestFcn(hObject, eventdata, handles)
if isequal(get(handles.figure1, 'waitstatus'), 'waiting')
    % The GUI is still in UIWAIT, us UIRESUME
    uiresume(handles.figure1);
else
    % The GUI is no longer waiting, just close it
    delete(handles.figure1);
end

% --- Executes on key press over figure1 with no controls selected.
function figure1_KeyPressFcn(hObject, eventdata, handles)
% Check for "enter" or "escape"
if isequal(get(hObject,'CurrentKey'),'escape')
    % User said no by hitting escape
    handles.output = 'Cancel';
    
    % Update handles structure
    guidata(hObject, handles);
    
    uiresume(handles.figure1);
end
if isequal(get(hObject,'CurrentKey'),'return')
    uiresume(handles.figure1);
end    





