% Script matlabExamples

% This script uses the main functions available in the toolbox to show how
% they can be used in real contexts.

% Auteur : Vronique Zambon
% Compagnie : Telops Inc.
% -----  Registre de changements :  ------------------------------------------------------
% Version  Date          Nom    Commentaires
% 
%  Copyright Telops 2020
%  $Revision:  $
%  $Author:  $
%  $LastChangedDate:  $
%  $HeadURL:  $

%% Data location path

% Use demo files of the same name provided with the toolbox to run the demo
% file.
firework_path = 'C:\Telops\RevealIR Demo Data\Fireworks.hcc';
soldering_iron_path = 'C:\Telops\RevealIR Demo Data\Soldering iron.hcc';
output_file_path = 'C:\Telops\RevealIR Demo Data\new_hcc.hcc';

%% Load sequence data
% only the 50th first frames are loaded 
filename = firework_path;
[data, header, specialPixelMap,specialNonBadPixelMap] = readIRCam(filename,'Frames', 1:50);
frame = data(1,:);


%% Print data
clc
image_2D = formImage(header(1), frame); % form the 2D vector of the data
cLim = imageScalingLimits(frame);
figure(1)
imagesc(image_2D, cLim) % draw the image
axis 'image'
colorbar


%% Area of Interest
clc
aoi = buildAoi(500-400, 400-300, 400, 300); % define the ROI
idx_aoi = getAoiIndices(header(1,:), aoi); % get the index of the ROI's pixels in the data vector

aoi_data = frame(idx_aoi); % get only the data of the ROI
op = aoi;
op.ReverseX = header(1).ReverseX;
op.ReverseY = header(1).ReverseY;
aoi_2D = formImage(op, aoi_data);
cLim = imageScalingLimits(aoi_data);
figure(2)
imagesc(aoi_2D, cLim) % draw the image
axis 'image'
colorbar

%% Max temporal profil
clc
% create the time vector
time = double([header.POSIXTime])+double([header.SubSecondTime])*1e-7; 
% the posixTime gives the times precise to the second 
% and the subsecond time needs to be used to achieve better precision
time = time-double(header(1).POSIXTime)-double(header(1).SubSecondTime)*1e-7;

figure(3)
plot(time, max(data')-273.15) % data in celsius degree
xlabel('time [s]')
ylabel('temperature [oC]')

%% Saturated pixel map
clc
[data, header, SPM] = readIRCam(soldering_iron_path);
%   OUTPUT OF readIRCam
%       Data : pixel data
%              - <NFrames, Width x Height> array by default
%              - <NFrames, NRows x Height> array when specific 'Rows' are requested
%              - empty array when only 'HeadersOnly' is requested
%       Header : a vector of <Nframes x 1> header structures, one for each decoded frame
%       specialPixelMap : Map of the special pixels with the corresponding
%       code
%       specialNonBadPixelMap : Map of the special pixel after bad pixel
%       replacement
%       The special pixel code are : 
%       LowerDigitalSaturation = 1;
%       UpperDigitalSaturation = 2;
%       SpecialTag3 = 3;
%       SpecialTag4 = 4;
%       SpecialTag5 = 5;
%       SpecialTag6 = 6;
%       SpecialTag7 = 7;
%       SpecialTag8 = 8;
%       SpecialTag9 = 9;
%       BlankImageTranslation = 10;
%       BadEmissivityCorrection = 11;
%       UnderCalibrationRange = 12;
%       OverCalibrationRange = 13;
%       BadPixelTag = 14;
%       SaturatedPixelTag = 15;

% extract the saturated pixel map
BPMap1 = SPM(1,:)==15;
figure(4)
imagesc(formImage(header(1),BPMap1));
axis 'image'
colormap(gray)

%% Merge EHDRI
clc
mergeHdrSequence()

%% Check data integrity
clc
% to make sure there were no frame loss during the acquisitions
% check if the frameID of the sequence's frames are consecutive
[~, h] = readIRCam(soldering_iron_path, 'HeadersOnly', true);
if ~any(diff(double([h.FrameID]))~=1)
    statut='PASS';
else
    statut='FAIL';
end
disp(statut)


%% Export flag data and write hcc file
[d,header] = readIRCam(firework_path);
% select the data that were flag during the acquistion
data1 = d([header.FrameFlag]==1, :);
header1 = header([header.FrameFlag]==1, :);

writeIRCam(header1, data1, 'D:\Training data\new_hccFlag.hcc')
