%'update_imadoc': update an xml file with geometric calibration parameters
%--------------------------------------------------------------------------
%  function update_imadoc(GeometryCalib,outputfile)
%
%INPUT:
% GeometryCalib: structure containing the calibration parameters
% outputfile: xml file to modify
%-------------------------------------------------------------
function errormsg=update_imadoc(GeometryCalib,outputfile)
errormsg='';
testappend=0;
%% backup the output file if it already exist, and read it
if exist(outputfile,'file');%=1 if the output file already exists, 0 else
    testappend=1;
    backupfile=outputfile;
    testexist=2;
    while testexist==2
        backupfile=[backupfile '~'];
        testexist=exist(backupfile,'file');
    end
    [success,message]=copyfile(outputfile,backupfile);%make backup
    if success~=1
        errormsg=['errror in xml file backup: ' message];
        return
    end
    t=xmltree(outputfile); %read the file
    title=get(t,1,'name');
    if strcmp(title,'ImaDoc')
        testappend=1;
        %if the xml file is  ImaDoc
        uid_calib=find(t,'ImaDoc/GeometryCalib');
        if isempty(uid_calib)  %if GeometryCalib does not already exists, create it
            [t,uid_calib]=add(t,1,'element','GeometryCalib');
        else %if GeometryCalib already exists, delete its content
            uid_child=children(t,uid_calib);
            t=delete(t,uid_child);
        end
    end
end

%% create a new xml file
if ~testappend
    t=xmltree;
    t=set(t,1,'name','ImaDoc');
    % in case of movie (avi file), copy timing info in the new xml file
    [pp,outputroot]=fileparts(outputfile);
    %     imainfo=[];
    if exist(fullfile(pp,[outputroot '.avi']),'file')
        FileName=fullfile(pp,[outputroot '.avi']);
        hhh=which('videoreader');
        if isempty(hhh)%use old video function of matlab
            imainfo=aviinfo(FileName);
            imainfo.FrameRate=imainfo.FramesPerSecond;
            imainfo.NumberOfFrames=imainfo.NumFrames;
        else %use video function videoreader of matlab
            imainfo=get(videoreader(FileName));
        end
        if ~isempty(imainfo)
            [t,uid_camera]=add(t,1,'element','Camera');
            Camera.TimeUnit='s';
            Camera.BurstTiming.Time=0;
            Camera.BurstTiming.Dti=1/imainfo.FrameRate;
            Camera.BurstTiming.NbDti=imainfo.NumberOfFrames-1;
            t=struct2xml(Camera,t,uid_camera);
        end
    end
    [t,uid_calib]=add(t,1,'element','GeometryCalib');
end

%% save the output file
t=struct2xml(GeometryCalib,t,uid_calib); 
save(t,outputfile);
