%'mouse_motion': permanently called by mouse motion over a figure (Callback for 'WindowButtonMotionFcn' of the figure)
%-----------------------------------------------------------------------
%
% function mouse_motion(hObject,eventdata,handles)
% activated by the command:
% set(hObject,'WindowButtonMotionFcn',{'mouse_motion',handles})
% where hObject is the handle of the figure
%
%AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
%  Copyright Joel Sommeria, 2008, LEGI / CNRS-UJF-INPG, sommeria@coriolis-legi.org.
%AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
%     This file is part of the toolbox UVMAT.
% 
%     UVMAT is free software; you can redistribute it and/or modify
%     it under the terms of the GNU General Public License as published by
%     the Free Software Foundation; either version 2 of the License, or
%     (at your option) any later version.
% 
%     UVMAT is distributed in the hope that it will be useful,
%     but WITHOUT ANY WARRANTY; without even the implied warranty of
%     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%     GNU General Public License (file UVMAT/COPYING.txt) for more details.
%AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA

function mouse_motion(hObject,eventdata,handles)

if ~exist('handles','var')
    return
end
currentfig=hObject;
hhcurrentfig=guidata(currentfig);
test_zoom=get(hhcurrentfig.zoom,'Value');%test for zoom activated on the current figure
test_draw=0;%test for mouse drawing of object, =0 by default
test_object=0; %test for object editing or creation 
test_edit=isfield(handles,'edit') && get(handles.edit,'Value');% edit test for mouse shap: an arrow
test_zoom_draw=0; % test for zoom drawing 
test_ruler=0;%test for active ruler 
test_piv=0;% test for PIV correlation display
huvmat=findobj(allchild(0),'tag','uvmat');%find the uvmat interface handle
if ~isempty(huvmat)
    hhuvmat=guidata(huvmat);
end
if ~isempty(huvmat)
    UvData=get(huvmat,'UserData');
    test_ruler=isfield(UvData,'MouseAction') && isequal(UvData.MouseAction,'ruler');
end
hciv=findobj(allchild(0),'tag','civ');%find the uvmat interface handle
if ~isempty(hciv) && strcmp(get(currentfig,'tag'),'view_field')
    hhciv=guidata(hciv);
    test_piv =get(hhciv.TestCiv1,'Value');
end

%find the current axe 'haxes' and display the current mouse position or uicontrol tag
text_displ_1='';
text_displ_2='';
text_displ_3='';
text_displ_4='';

AxeData=[];%default
mouse=[];
xy=[];%default

pointershape='arrow';% default pointer is an arrow 

xy_fig=get(currentfig,'CurrentPoint');% current point of the current figure (gcbo)
hchild=get(currentfig,'Children');%handles of all objects in the current figure

%% loop on all the objects in the current figure and detect whether the mouse is over a plot  axes
haxes=[];
for ichild=1:length(hchild)
    obj_pos=get(hchild(ichild),'Position');
    if numel(obj_pos)~=4% for some versions of matlab a uicontextmenu appears
        continue
    end%position of the object
    if xy_fig(1) >=obj_pos(1) && xy_fig(2) >= obj_pos(2)&& xy_fig(1) <=obj_pos(1)+obj_pos(3) && xy_fig(2) <= obj_pos(2)+obj_pos(4);
        htype=get(hchild(ichild),'Type');%type of the crrent child
        %if the mouse is over an axis, look at the data
        if isequal(htype,'axes')
            haxes=hchild(ichild);
            xy=get(haxes,'CurrentPoint');%xy(1,1),xy(1,2): current x,y positions in axes coordinates
            AxeData=get(haxes,'UserData');% data attached to the axis
            if isfield(AxeData,'Drawing')&& ~isempty(AxeData.Drawing)
                test_draw=~isequal(AxeData.Drawing,'off');%=1 if mouse drawing of object is active
            end
            test_zoom_draw=test_draw && isequal(AxeData.Drawing,'zoom')&& isfield(AxeData,'CurrentOrigin') && isequal(get(gcf,'SelectionType'),'normal');
            test_object=test_draw && isfield(AxeData,'CurrentObject') && ~isempty(AxeData.CurrentObject) && ishandle(AxeData.CurrentObject);
            if ~test_edit && ~test_zoom_draw && ~test_ruler
                pointershape='crosshair';%set pointer with cross shape (default when mouse is over an axis)
            end
            FigData=get(currentfig,'UserData');
            tagaxes=get(haxes,'tag');
            if isfield(FigData,tagaxes)
                eval(['Field=FigData.' tagaxes ';'])
                if isfield(Field,'ListVarName')
                    [CellVarIndex,NbDim,VarType]=find_field_indices(Field);%analyse the physical fields contained in Field
%                     if isfield(Field,'Mesh') && ~isempty(Field.Mesh)
                        text_displ_1='';
                        text_displ_2='';
                        text_displ_3='';
                        text_displ_4='';
                        for icell=1:numel(CellVarIndex)%look for all physical fields
                            if NbDim(icell)==2 % select 2D field
                                if  isfield(Field,'Mesh') && ~isempty(Field.Mesh)&& ~isempty(VarType{icell}.coord_x) && ~isempty(VarType{icell}.coord_y)%case of unstructured data
                                    eval(['X=Field.' Field.ListVarName{VarType{icell}.coord_x} ';'])
                                    eval(['Y=Field.' Field.ListVarName{VarType{icell}.coord_y} ';'])
                                    flag_vec=(X<(xy(1,1)+Field.Mesh/3) & X>(xy(1,1)-Field.Mesh/3)) & ...%flagx=1 for the vectors with x position selected by the mouse
                                        (Y<(xy(1,2)+Field.Mesh/3) & Y>(xy(1,2)-Field.Mesh/3));%f
                                    ivec=find(flag_vec,1);% search the (first) selected vector index ivec                          
                                    hhh=findobj(haxes,'Tag','vector_marker');
                                    if ~isempty(ivec)
                                        % mark the vectors with a circle in the absence of other operations
                                        if ~test_object && ~test_edit && ~test_ruler
                                            pointershape='arrow'; %mouse indicates  the detection of a vector
                                            if isempty(hhh)
                                                set(0,'CurrentFigure',currentfig)
                                                set(currentfig,'CurrentAxes',haxes)
                                                rectangle('Curvature',[1 1],...
                                                    'Position',[X(ivec)-Field.Mesh/2 Y(ivec)-Field.Mesh/2 Field.Mesh Field.Mesh],'EdgeColor','m',...
                                                    'LineStyle','-','Tag','vector_marker');
                                            else
                                                set(hhh,'Visible','on')
                                                set(hhh,'Position',[X(ivec)-Field.Mesh/2 Y(ivec)-Field.Mesh/2 Field.Mesh Field.Mesh])
                                            end
                                        end
                                        %display the field values
                                        for ivar=1:numel(CellVarIndex{icell})
                                            VarName=Field.ListVarName{CellVarIndex{icell}(ivar)};
                                            eval(['VarVal=Field.' VarName '(ivec);'])
                                            var_text=[VarName '=' num2str(VarVal,3) ','];
                                            if isequal(ivar,VarType{icell}.coord_x)||isequal(ivar,VarType{icell}.coord_y)||isequal(ivar,VarType{icell}.coord_z)
                                                text_displ_1=[text_displ_1 var_text];
                                            elseif isequal(ivar,VarType{icell}.vector_x)||isequal(ivar,VarType{icell}.vector_y)||isequal(ivar,VarType{icell}.vector_z)
                                                text_displ_3=[text_displ_3 var_text];
                                            else
                                                text_displ_4=[text_displ_4 var_text];
                                            end
                                        end
                                    else
                                        if ~isempty(hhh)
                                            set(hhh,'Visible','off')
                                        end
                                    end
                                elseif numel(VarType{icell}.coord) >=2 %structured coordinates
                                    eval(['y=Field.' Field.ListVarName{VarType{icell}.coord(1)} ';'])
                                    eval(['x=Field.' Field.ListVarName{VarType{icell}.coord(2)} ';'])
                                    VarName=Field.ListVarName{CellVarIndex{icell}(1)};
                                    eval(['nxy=size(Field.' VarName ');']);
%                                     nxy(1)=numel(y);
%                                     nxy(2)=numel(x);
                                    MaxAY=max(y(1),y(end));
                                    MinAY=min(y(1),y(end));
                                    if (xy(1,1)>x(1))&(xy(1,1)<x(end))&(xy(1,2)<MaxAY)&(xy(1,2)>MinAY)
                                        indx0=1+round((nxy(2)-1)*(xy(1,1)-x(1))/(x(end)-x(1)));% index x of pixel
                                        indy0=1+round((nxy(1)-1)*(xy(1,2)-y(1))/(y(end)-y(1)));% index y of pixel
                                        if indx0>=1 & indx0<=nxy(2) & indy0>=1 & indy0<=nxy(1)
                                            text_displ_2=['i='  num2str(indx0) ',j=' num2str(indy0) ','];
                                            for ivar=1:numel(CellVarIndex{icell})
                                                VarName=Field.ListVarName{CellVarIndex{icell}(ivar)};
                                                eval(['VarVal=Field.' VarName '(indy0,indx0,:);'])
                                                var_text=[VarName '=' num2str(VarVal) ','];
                                                text_displ_2=[text_displ_2 var_text];
                                            end
                                        end
                                    end
                                end
                            end
                        end
%                     end
                    if strcmp(text_displ_1,'')
                        text_displ_1=['x=' num2str(xy(1,1),3) ',y=' num2str(xy(1,2),3) ','];
                    end
                    if isfield(Field,'PlaneCoord') && isfield(Field,'ZIndex')
                        text_displ_1=[text_displ_1 ' z=' num2str(Field.PlaneCoord(Field.ZIndex,3))]; %TODO: generaliser au cas avec angle
                    end
                    %coordinate transform if proj_coord differs from menu_coord A REVOIR
                    if isfield(Field,'CoordType')
                        mouse.CoordType=Field.CoordType;
                    end
                    if isfield(Field,'CoordUnit')
                        mouse.CoordUnit=Field.CoordUnit;
                    end
                    if isfield(mouse,'CoordType')
                        if isequal(mouse.CoordType,'px')
                            mouse.CoordUnit='px';
                        end
                    else
                        mouse.CoordUnit='';%default
                    end
                    if test_piv 
                       par=civ('read_param_civ1',hhciv);
                        if isfield(Field,'A')
                            dx=str2double(par.dx);
                            dy=str2double(par.dy);
                            xround=x(1)+dx*round((xy(1,1)-x(1))/dx);% index x of pixel
                            yround=y(1)+dy*round((xy(1,2)-y(1))/dy);% index y of pixel
                        end
                        % mark the correlation box with a rectangle
                        ibx2=floor((str2double(par.ibx)-1)/2);
                        iby2=floor((str2double(par.iby)-1)/2);
                        isx2=floor((str2double(par.isx)-1)/2);
                        isy2=floor((str2double(par.isy)-1)/2);
                        hhh=findobj(haxes,'Tag','PIV_box_marker');
                        hhhh=findobj(haxes,'Tag','PIV_search_marker');
                        if isempty(hhh)
                            %hstack=findobj(allchild(0),'Type','figure');%current stack order of figures in matlab
                            set(0,'CurrentFigure',currentfig)
                            set(currentfig,'CurrentAxes',haxes)
                            rectangle('Curvature',[0 0],...
                                'Position',[xround-ibx2 yround-iby2 2*ibx2 2*iby2],'EdgeColor','m',...
                                'LineStyle','-','Tag','PIV_box_marker');
                            rectangle('Curvature',[0 0],...
                                'Position',[xround-isx2 yround-isy2 2*isx 2*isy],'EdgeColor','m',...
                                'LineStyle','- -','Tag','PIV_search_marker');
                            % set(0,'Children',hstack);%put back the initial figure stack after plot creation
                        else
%                             set(hhh,'Visible','on')
                            set(hhh,'Position',[xround-ibx2 yround-iby2 2*ibx2 2*iby2])
                            set(hhhh,'Position',[xround-isx2 yround-isy2 2*isx2 2*isy2])
                        end
                        Asub=Field.A(xround-ibx2:xround+ibx2,yround-iby2:yround+iby2);
                        Asub=reshape(Asub,[],1);
                        rangx(1)=-(isx2-ibx2);
                        rangx(2)=isx2-ibx2;
                        rangy(1)=isy2-iby2;
                        rangy(2)=-(isy2-iby2);
                        for id=rangx(1):rangx(2)
                            for jd=rangy(2):rangy(1)
                                Bsub=Field.B(xround-ibx2+id:xround+ibx2+id,yround-iby2+jd:yround+iby2+jd);
                                Bsub=reshape(Bsub,[],1);
                                correl(jd-rangy(2)+1,id-rangx(1)+1)=corr(double(Asub),double(Bsub));
                            end
                        end
                        %correl=uint8(63.5*correl+63.5);
                        hcorr=[];
                        if isfield(AxeData,'CurrentCorrImage')                        
                            hcorr=AxeData.CurrentCorrImage;
                            if ~ishandle(hcorr)
                                hcorr=[];
                            end
                        end
                        if isempty(hcorr)
                            coorfig=findobj(allchild(0),'tag','corrfig');
                            if isempty(coorfig)
                                corrfig=figure;
                                set(corrfig,'tag','corrfig')
                            end
                            set(0,'CurrentFigure',corrfig)
                            AxeData.CurrentCorrImage=imagesc(rangx,rangy,correl,[0 1]);
                            colorbar
%                             map_r=ones(42,1)*[1 0 0];
%                             map_g=ones(11,1)*[0 1 0];
%                             map_b=ones(11,1)*[0 0 1];
%                             map=[map_r;map_g;map_b];
%                             set(corrfig,'colormap',map)
                            set(haxes,'UserData',AxeData)
                        else
                            set(AxeData.CurrentCorrImage,'CData',correl)
                        end        
                    end
                end
            end      
        end
    end
end
set(handles.text_display_1,'String',text_displ_1);
set(handles.text_display_2,'String',text_displ_2);
set(handles.text_display_3,'String',text_displ_3);
set(handles.text_display_4,'String',text_displ_4);

%%%%%%%%%%%%%
%% draw a zoom rectangle if no object creation is selected
if test_zoom_draw 
   xy_rect=AxeData.CurrentOrigin;
   if ~isempty(xy_rect) 
        rect(1)=min(xy(1,1),xy_rect(1));%origin rectangle, x coordinate
        rect(2)=min(xy(1,2),xy_rect(2));%origin rectangle, y coordinate
        rect(3)=abs(xy(1,1)-xy_rect(1));%rectangle width
        rect(4)=abs(xy(1,2)-xy_rect(2));%rectangle height
        if rect(3)>0 & rect(4)>0
            if isfield(AxeData,'CurrentRectZoom')& ishandle(AxeData.CurrentRectZoom)
                set(AxeData.CurrentRectZoom,'Position',rect);%update the rectangle position
            else
                AxeData.CurrentRectZoom=rectangle('Position',rect,'LineStyle',':','Tag','rect_zoom');
                set(haxes,'UserData',AxeData)
            end
        end
   end
    pointershape='arrow';
end

%%%%%%%%%%%%%%%%%
%% create or modify an object

if ~isempty(huvmat) && test_object
    PlotData=get(AxeData.CurrentObject,'UserData');
    huvmat=findobj(allchild(0),'Name','uvmat');%find the uvmat interface handle
    if ~isempty(huvmat)
        UvData=get(huvmat,'UserData');
        if ~isfield(PlotData,'IndexObj')
             return
        end
        ObjectData=UvData.Object{PlotData.IndexObj};
        XYData=AxeData.CurrentOrigin;
        if isequal(AxeData.Drawing,'create') && isfield(AxeData,'CurrentOrigin') && ~isempty(AxeData.CurrentOrigin)
           if strcmp(ObjectData.Style,'line')||strcmp(ObjectData.Style,'polyline')||strcmp(ObjectData.Style,'polygon')||strcmp(ObjectData.Style,'points')
              xy(1,3)=0;
              ObjectData.Coord=[ObjectData.Coord ;xy(1,:)];
             % ObjectData.Coord(end,:)=xy(1,:);
           elseif strcmp(ObjectData.Style,'rectangle')||strcmp(ObjectData.Style,'ellipse')||strcmp(ObjectData.Style,'volume')
              ObjectData.Coord(1,1)=(xy(1,1)+XYData(1))/2;%origin rectangle, x coordinate
              ObjectData.Coord(1,2)=(xy(1,2)+XYData(2))/2;
              ObjectData.RangeX=abs(xy(1,1)-XYData(1))/2;%rectangle width
              ObjectData.RangeY=abs(xy(1,2)-XYData(2))/2;%rectangle height
           elseif isequal(ObjectData.Style,'plane') %case of 'plane'
                DX=(xy(1,1)-ObjectData.Coord(1,1));
                DY=(xy(1,2)-ObjectData.Coord(1,2));
                ObjectData.Phi=(angle(DX+i*DY))*180/pi;%rectangle widt
                if isfield(ObjectData,'RangeX')
                    XMax=sqrt(DX*DX+DY*DY);
                    if XMax>max(ObjectData.RangeX)
                        ObjectData.RangeX=[min(ObjectData.RangeX) XMax];
                    end
                end
           end
            plot_object(ObjectData,[],AxeData.CurrentObject,'m');
            pointershape='crosshair';
        elseif  isequal(AxeData.Drawing,'translate')
            DX=xy(1,1)-XYData(1);%translation from initial position
            DY=xy(1,2)-XYData(2);
            ObjectData.Coord(:,1)=ObjectData.Coord(:,1)+DX;
            ObjectData.Coord(:,2)=ObjectData.Coord(:,2)+DY;
            plot_object(ObjectData,[],AxeData.CurrentObject,'m');
            pointershape='fleur';
        elseif  isequal(AxeData.Drawing,'deform')
            ind_move=AxeData.CurrentIndex;
            ObjectData.Coord(ind_move,1)=xy(1,1);
            ObjectData.Coord(ind_move,2)=xy(1,2);
            plot_object(ObjectData,[],AxeData.CurrentObject,'m');
            pointershape='circle';
        end
    end
end    

%% detect calibration points if the GUI geometry_calib is opened
h_geometry_calib=findobj(allchild(0),'Name','geometry_calib'); %find the geomterty_calib GUI
if ~test_zoom && ~isempty(h_geometry_calib)
    pointershape='crosshair';%default for geometry_calib: ready to create new points
    hh_geometry_calib=guidata(h_geometry_calib);
    if  ~isempty(xy)
        h_ListCoord=hh_geometry_calib.ListCoord; %findobj(h_geometry_calib,'Tag','ListCoord');
        Coord=get(h_ListCoord,'String');
        data=read_geometry_calib(Coord);%transform char cell to numbers
        if size(data.Coord,2)>=5
            XCoord=(data.Coord(:,4));
            YCoord=(data.Coord(:,5));
            xy=get(haxes,'CurrentPoint');%xy(1,1),xy(1,2): current x,y positions in axes coordinates
            if ~isempty(xy)
                xlim=get(haxes,'XLim');
                ind_range_x=abs((xlim(2)-xlim(1))/50);
                ylim=get(haxes,'YLim');
                ind_range_y=abs((ylim(2)-ylim(1))/50);
                ind_range=sqrt(ind_range_x*ind_range_y);
                index_point=find((XCoord<xy(1,1)+ind_range) & (XCoord>xy(1,1)-ind_range) & ...%flagx=1 for the vectors with x position selected by the mouse
                              (YCoord<xy(1,2)+ind_range) & (YCoord>xy(1,2)-ind_range),1);%find the first calibration point in the neighborhood of the mouse
                if ~isempty(index_point)
                    pointershape='arrow';% default pointer is an arrow 
                end
                hh=findobj('Tag','calib_points');%look for handle of calibration points
               if ~isempty(hh) && ~isempty(get(hh,'UserData')) && get(hh_geometry_calib.edit_append,'Value') 
                    index_point=get(hh,'UserData');
                    XCoord(index_point)=xy(1,1);
                    YCoord(index_point)=xy(1,2);
                    set(hh,'XData',XCoord)
                    set(hh,'YData',YCoord)
               end
                if ~isempty(index_point)
                    set(h_ListCoord,'Value',index_point)%mrk the point on the GUI geometry_calib
                    hhh=findobj('Tag','calib_marker');%look for handle of point marker (circle)
                    if ~isempty(hhh)
                        set(hhh,'Position',[XCoord(index_point)-ind_range/2 YCoord(index_point)-ind_range/2 ind_range ind_range])
                    end
                end
            end
        end
    end
end

%% draw ruler
if test_ruler && isequal(AxeData.Drawing,'ruler')
           if isfield(UvData,'RulerHandle')
               pointershape='crosshair';
                RulerCoord=[UvData.RulerCoord ;xy(1,1:2)];
                set(UvData.RulerHandle,'XData',RulerCoord(:,1));
                set(UvData.RulerHandle,'YData',RulerCoord(:,2));
           end
end

%% update the mouse pointer
set(currentfig,'Pointer',pointershape);
