%'get_file_series': determine the list of file names and file indices for functions called by 'series'. 
%------------------------------------------------------------------------
% [filecell,i1_series,i2_series,j1_series,j2_series]=get_file_series(Param)
%
% OUTPUT:
% filecell{iview,fileindex}: cell array representing the list of file names
%        iview: line in the table corresponding to a given file series
%        fileindex: file index within  the file series, 
% i1_series{iview}(ref_j,ref_i)... are the corresponding arrays of indices i1,i2,j1,j2, depending on the input line iview and the two reference indices ref_i,ref_j 
% i1_series{iview}(fileindex) expresses the same indices as a 1D array in file indices

% INPUT:
% Param: structure of input parameters as read from the GUI series (by the function read_GUI)

function [filecell,i1_series,i2_series,j1_series,j2_series]=get_file_series(Param)

filecell={};
InputTable=Param.InputTable;
first_i=Param.IndexRange.first_i;
incr_i=Param.IndexRange.incr_i;
last_i=Param.IndexRange.last_i;
ref_i=first_i:incr_i:last_i;
ref_j=[];
if isfield(Param.IndexRange,'first_j')
    first_j=Param.IndexRange.first_j;
    incr_j=Param.IndexRange.incr_j;
    last_j=Param.IndexRange.last_j;
    ref_j=first_j:incr_j:last_j;
end

%% determine the list of input file names
nbmissing=0;

for iview=1:size(InputTable,1)
    r.mode='';
    if isfield (Param.IndexRange,'PairString')
        if ischar(Param.IndexRange.PairString)
            Param.IndexRange.PairString={Param.IndexRange.PairString};
        end
        r=regexp(Param.IndexRange.PairString{iview,1},'(?<mode>(Di=)|(Dj=)) -*(?<num1>\d+)\|(?<num2>\d+)','names');
        if isempty(r)
            r=regexp(Param.IndexRange.PairString{iview,1},'(?<num1>\d+)(?<mode>-)(?<num2>\d+)','names');
        end
        % TODO case of free pairs:
        %r=regexp(pair_string,'.*\D(?<num1>[\d+|*])(?<delim>[-||])(?<num2>[\d+|*])','names');
    end
    if isempty(r)||isempty(r.mode)
        r(1).num1='';
        r(1).num2='';
        if strcmp(Param.IndexRange.PairString{iview,1},'j=*-*')
            r(1).mode='*-*';
        else
        r(1).mode='';
        end
    end
    if isequal(r(1).mode,'*-*')% free pairs
        FilePath=fullfile(InputTable{iview,1},InputTable{iview,2});
        fileinput=[InputTable{iview,3} InputTable{iview,4} InputTable{iview,5}];
        [tild,tild,tild,i1_series{iview},i2_series{iview},j1_series{iview},j2_series{iview},NomType,FileType,MovieObject,i1_input,i2_input,j1_input,j2_input]=find_file_series(FilePath,fileinput);
        i1_series{iview}=squeeze(i1_series{iview}(1,:,:)); %first  pair index
        check_select=i1_series{iview}>=first_i & i1_series{iview}<=last_i;
        i1_series{iview}=i1_series{iview}(check_select);    
        i2_series{iview}=[]; %first  pair index
        j1_series{iview}=squeeze(j1_series{iview}(1,:,:)); %first  pair index
        j2_series{iview}=squeeze(j2_series{iview}(1,:,:)); %first  pair index
        j1_series{iview}=j1_series{iview}(check_select);
        j2_series{iview}=j2_series{iview}(check_select);
    else
        [i1_series{iview},i2_series{iview},j1_series{iview},j2_series{iview}]=find_file_indices(ref_i,ref_j,str2num(r.num1),str2num(r.num2),r.mode);
    end
        
    %case of pairs (.nc files)
    i2=[];j1=[];j2=[];
    for ifile=1:numel(i1_series{iview})
        i1=i1_series{iview}(ifile);
        if ~isempty(i2_series{iview})
            i2=i2_series{iview}(ifile);
        end
        if ~isempty(j1_series{iview})
            j1=j1_series{iview}(ifile);
        end
        if ~isempty(j2_series{iview})
            j2=j2_series{iview}(ifile);
        end
         filecell{iview,ifile}=fullfile_uvmat(InputTable{iview,1},InputTable{iview,2},InputTable{iview,3},InputTable{iview,5},InputTable{iview,4},i1,i2,j1,j2);
    end
end


function [i1_series,i2_series,j1_series,j2_series]=find_file_indices(ref_i,ref_j,num1,num2,mode)
i1_series=ref_i;%default
j1_series=[];
if ~isempty(ref_j)
    [i1_series,j1_series]=meshgrid(ref_i,ref_j);
end
i2_series=i1_series;
j2_series=j1_series;

switch mode
    case 'Di='  %  case 'series(Di)')
        i1_series=i1_series-num1;
        i2_series=i2_series+num2;
    case 'Dj='  %  case 'series(Dj)'
        j1_series=j1_series-num1;
        j2_series=j2_series+num2;
    case '-'  % case 'bursts'
        j1_series=num1*ones(size(i1_series));
        j2_series=num2*ones(size(i1_series));
end